<?php
require_once '../includes/auth.php';

if (!isMentorLoggedIn()) {
    header('Location: index.php');
    exit;
}

$mentor_id = $_SESSION['mentor_id'];
$mentor_name = $_SESSION['mentor_name'];
$mentor_code = $_SESSION['mentor_code'];

// Fetch mentor stats
$stmt = $pdo->prepare("SELECT 
    COUNT(*) as started,
    SUM(CASE WHEN is_completed = 1 THEN 1 ELSE 0 END) as completed
    FROM survey_responses WHERE mentor_id = ?");
$stmt->execute([$mentor_id]);
$stats = $stmt->fetch();

$survey_link = BASE_URL . "/index.php?mentor=" . $mentor_code;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Mentor Dashboard - BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 font-sans">
    <div class="max-w-4xl mx-auto p-8">
        <div class="flex justify-between items-center mb-8">
            <h1 class="text-3xl font-bold text-gray-800">Welcome, <?php echo htmlspecialchars($mentor_name); ?>!</h1>
            <a href="logout.php" class="text-red-600 hover:text-red-800">Logout</a>
        </div>

        <!-- Link Card -->
        <div class="bg-white rounded-lg shadow-lg p-6 mb-8 border-l-4 border-green-500">
            <h2 class="text-xl font-bold text-gray-800 mb-4">🔗 Your Unique Survey Link</h2>
            <div class="flex items-center space-x-4">
                <input type="text" value="<?php echo $survey_link; ?>" readonly class="flex-1 bg-gray-100 border border-gray-300 rounded px-4 py-2 text-gray-600 font-mono text-sm">
                <button onclick="navigator.clipboard.writeText('<?php echo $survey_link; ?>')" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 transition">Copy Link</button>
            </div>
        </div>

        <!-- Stats -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-gray-500 text-sm font-medium uppercase">Total Started</h3>
                <p class="text-3xl font-bold text-gray-900 mt-2"><?php echo number_format($stats['started']); ?></p>
            </div>
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-gray-500 text-sm font-medium uppercase">Completed Surveys</h3>
                <p class="text-3xl font-bold text-green-600 mt-2"><?php echo number_format($stats['completed']); ?></p>
            </div>
             <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-gray-500 text-sm font-medium uppercase">Conversion Rate</h3>
                <p class="text-3xl font-bold text-blue-600 mt-2">
                    <?php echo $stats['started'] > 0 ? round(($stats['completed'] / $stats['started']) * 100, 1) : 0; ?>%
                </p>
            </div>
        </div>
    </div>
</body>
</html>
