<?php
// includes/questions.php
require_once __DIR__ . '/db.php';

function getSurveyDetails($slug) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM surveys WHERE slug = ? AND is_active = 1");
    $stmt->execute([$slug]);
    $survey = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$survey) return null;

    // Fetch Categories
    $stmt = $pdo->prepare("SELECT * FROM survey_categories WHERE survey_id = ? ORDER BY sort_order ASC");
    $stmt->execute([$survey['id']]);
    $survey['categories'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Fetch Parts
    $stmt = $pdo->prepare("SELECT * FROM survey_parts WHERE survey_id = ? ORDER BY sort_order ASC");
    $stmt->execute([$survey['id']]);
    $survey['parts'] = $stmt->fetchAll(PDO::FETCH_ASSOC);

    return $survey;
}

function getQuestions($slug) {
    global $pdo;
    
    // 1. Get Survey ID
    $stmt = $pdo->prepare("SELECT id FROM surveys WHERE slug = ? AND is_active = 1");
    $stmt->execute([$slug]);
    $survey_id = $stmt->fetchColumn();
    
    if (!$survey_id) {
        return [];
    }
    
    // 2. Get Questions with Category and Part info
    $stmt = $pdo->prepare("
        SELECT q.id, q.question_text, q.sort_order, q.category_id, q.part_id,
               p.title as part_title, c.name as category_name
        FROM survey_questions q
        LEFT JOIN survey_parts p ON q.part_id = p.id
        LEFT JOIN survey_categories c ON q.category_id = c.id
        WHERE q.survey_id = ? 
        ORDER BY p.sort_order ASC, q.sort_order ASC
    ");
    $stmt->execute([$survey_id]);
    $questions_db = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $final_questions = [];
    
    foreach ($questions_db as $q) {
        // 3. Get Options for each question
        $stmt_opt = $pdo->prepare("SELECT option_text FROM survey_options WHERE question_id = ? ORDER BY sort_order ASC");
        $stmt_opt->execute([$q['id']]);
        $options = $stmt_opt->fetchAll(PDO::FETCH_COLUMN);
        
        $final_questions[] = [
            'id' => $q['sort_order'], // Use sort_order as ID for frontend continuity (1, 2, 3...)
            'db_id' => $q['id'], // Keep DB ID for reference if needed
            'text' => $q['question_text'],
            'options' => $options,
            'category_id' => $q['category_id'],
            'part_id' => $q['part_id'],
            'part_title' => $q['part_title'],
            'category_name' => $q['category_name']
        ];
    }
    
    return $final_questions;
}
?>
