<?php
require_once '../includes/config.php';
require_once '../includes/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Invalid method']);
    exit;
}

$session_token = $_POST['session_token'] ?? null;
$time_taken = $_POST['time_taken'] ?? 0;

if (!$session_token) {
    echo json_encode(['success' => false, 'error' => 'Missing token']);
    exit;
}

// Anonymous completion
$respondent_data = [
    'time_taken' => $time_taken,
    'name' => null,
    'email' => null,
    'phone' => null
];

$response_id = completeSurvey($session_token, $respondent_data);

if ($response_id) {
    echo json_encode(['success' => true, 'response_id' => $response_id]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to complete survey']);
}
?>