<?php
require_once '../includes/auth.php';
requireAdminLogin();

$response_id = $_GET['id'] ?? null;

if (!$response_id) {
    header("Location: responses.php");
    exit;
}

// Fetch Response
$stmt = $pdo->prepare("SELECT r.*, m.mentor_name 
                       FROM survey_responses r 
                       LEFT JOIN mentors m ON r.mentor_id = m.id 
                       WHERE r.id = ?");
$stmt->execute([$response_id]);
$response = $stmt->fetch();

if (!$response) {
    die("Response not found.");
}

// Fetch Survey Details
$stmt = $pdo->prepare("SELECT * FROM surveys WHERE slug = ?");
$stmt->execute([$response['survey_type']]);
$survey = $stmt->fetch();

// Fetch Questions
$questions_map = [];
if ($survey) {
    $stmt = $pdo->prepare("SELECT * FROM survey_questions WHERE survey_id = ? ORDER BY sort_order ASC");
    $stmt->execute([$survey['id']]);
    $questions_db = $stmt->fetchAll();
    
    foreach ($questions_db as $q) {
        $questions_map[$q['sort_order']] = $q;
    }
}

// Decode Answers
$answers = json_decode($response['responses'], true);
if (!is_array($answers)) {
    $answers = [];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Response #<?php echo $response['id']; ?> - BodhiTree Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        @media print {
            .no-print { display: none; }
            body { background: white; }
            .sidebar { display: none; }
            .content { padding: 0; margin: 0; width: 100%; }
        }
    </style>
</head>
<body class="bg-gray-100 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div class="bg-slate-800 text-white w-64 flex-shrink-0 sidebar no-print">
            <div class="p-4 text-xl font-bold border-b border-slate-700">BodhiTree Admin</div>
            <nav class="mt-4">
                <a href="dashboard.php" class="block py-3 px-4 hover:bg-slate-700">Dashboard</a>
                <a href="surveys.php" class="block py-3 px-4 hover:bg-slate-700">Surveys</a>
                <a href="analytics.php" class="block py-3 px-4 hover:bg-slate-700">Analytics</a>
                <a href="mentors.php" class="block py-3 px-4 hover:bg-slate-700">Mentors</a>
                <a href="responses.php" class="block py-3 px-4 bg-slate-700 border-l-4 border-blue-500">Responses</a>
                <a href="freebies.php" class="block py-3 px-4 hover:bg-slate-700">Freebies</a>
                <a href="logout.php" class="block py-3 px-4 hover:bg-slate-700 text-red-300">Logout</a>
            </nav>
        </div>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-8 content">
            <div class="flex justify-between items-center mb-8 no-print">
                <div class="flex items-center">
                    <a href="responses.php" class="text-blue-600 hover:text-blue-800 mr-4">
                        &larr; Back
                    </a>
                    <h1 class="text-3xl font-bold text-gray-800">Response Details</h1>
                </div>
                <div>
                    <button onclick="window.print()" class="bg-slate-600 text-white font-bold py-2 px-4 rounded hover:bg-slate-700 mr-2">
                        Print / PDF
                    </button>
                </div>
            </div>

            <!-- Meta Data Card -->
            <div class="bg-white rounded-lg shadow p-6 mb-8">
                <h2 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2">Respondent Info</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-sm text-gray-500">Name</p>
                        <p class="font-medium"><?php echo htmlspecialchars($response['respondent_name']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="font-medium"><?php echo htmlspecialchars($response['email']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Phone</p>
                        <p class="font-medium"><?php echo htmlspecialchars($response['phone']); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Mentor</p>
                        <p class="font-medium"><?php echo htmlspecialchars($response['mentor_name'] ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Date Submitted</p>
                        <p class="font-medium"><?php echo date('F j, Y, g:i a', strtotime($response['started_at'])); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Survey Type</p>
                        <p class="font-medium">
                            <span class="px-2 py-1 bg-gray-200 rounded text-sm">
                                <?php echo htmlspecialchars($response['survey_type']); ?>
                            </span>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Quality Score</p>
                        <p class="font-medium">
                            <?php 
                                $score = $response['quality_score'] * 100;
                                $color = $score >= 80 ? 'text-green-600' : ($score >= 60 ? 'text-yellow-600' : 'text-red-600');
                            ?>
                            <span class="<?php echo $color; ?> font-bold"><?php echo $score; ?>%</span>
                            <?php if ($response['is_bot_suspected']): ?>
                                <span class="ml-2 text-red-600 font-bold bg-red-100 px-2 py-0.5 rounded text-xs">BOT SUSPECTED</span>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div>
                         <p class="text-sm text-gray-500">Device Fingerprint</p>
                         <p class="font-mono text-xs bg-gray-50 p-1 rounded inline-block"><?php echo htmlspecialchars($response['device_fingerprint']); ?></p>
                    </div>
                </div>
            </div>

            <!-- Answers Card -->
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-6 border-b pb-2">Survey Responses</h2>
                
                <div class="space-y-6">
                    <?php foreach ($answers as $q_sort_order => $answer_value): ?>
                        <?php 
                            $question_text = $questions_map[$q_sort_order]['question_text'] ?? "Question #$q_sort_order";
                            
                            // Format answer
                            $display_answer = '';
                            if (is_array($answer_value)) {
                                $display_answer = implode(', ', $answer_value);
                            } else {
                                $display_answer = $answer_value;
                            }
                        ?>
                        <div class="border-b border-gray-100 pb-4 last:border-0">
                            <h3 class="font-semibold text-gray-700 mb-2">
                                <span class="text-gray-400 mr-2">Q<?php echo $q_sort_order; ?></span>
                                <?php echo htmlspecialchars($question_text); ?>
                            </h3>
                            <div class="pl-8 text-gray-900 bg-blue-50 p-3 rounded-lg inline-block min-w-[50%]">
                                <?php echo nl2br(htmlspecialchars($display_answer)); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                    
                    <?php if (empty($answers)): ?>
                        <p class="text-gray-500 italic">No answers recorded.</p>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>
</body>
</html>
