<?php
require_once '../includes/auth.php';
requireAdminLogin();

$success_msg = '';
$error_msg = '';

// Handle Add Mentor
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_mentor'])) {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    // Generate code: MENTOR + Random 3 digits + Uppercase Name first 3 chars
    $code = 'MENTOR' . rand(100, 999) . strtoupper(substr(str_replace(' ', '', $name), 0, 3));
    
    try {
        $stmt = $pdo->prepare("INSERT INTO mentors (mentor_code, mentor_name, email, phone) VALUES (?, ?, ?, ?)");
        $stmt->execute([$code, $name, $email, $phone]);
        $success_msg = "Mentor added successfully! Code: <strong>$code</strong>";
    } catch (PDOException $e) {
        $error_msg = "Error adding mentor: " . $e->getMessage();
    }
}

// Fetch Mentors
$stmt = $pdo->query("SELECT m.*, 
    (SELECT COUNT(*) FROM survey_responses r WHERE r.mentor_id = m.id) as completion_count 
    FROM mentors m ORDER BY created_at DESC");
$mentors = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Mentors - BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div class="bg-slate-800 text-white w-64 flex-shrink-0">
            <div class="p-4 text-xl font-bold border-b border-slate-700">BodhiTree Admin</div>
            <nav class="mt-4">
                <a href="dashboard.php" class="block py-3 px-4 hover:bg-slate-700">Dashboard</a>
                <a href="surveys.php" class="block py-3 px-4 hover:bg-slate-700">Surveys</a>
                <a href="analytics.php" class="block py-3 px-4 hover:bg-slate-700">Analytics</a>
                <a href="mentors.php" class="block py-3 px-4 bg-slate-700 border-l-4 border-blue-500">Mentors</a>
                <a href="responses.php" class="block py-3 px-4 hover:bg-slate-700">Responses</a>
                <a href="freebies.php" class="block py-3 px-4 hover:bg-slate-700">Freebies</a>
                <a href="logout.php" class="block py-3 px-4 hover:bg-slate-700 text-red-300">Logout</a>
            </nav>
        </div>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-8">Mentors Management</h1>

            <?php if ($success_msg): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                    <?php echo $success_msg; ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error_msg): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                    <?php echo $error_msg; ?>
                </div>
            <?php endif; ?>

            <!-- Add Mentor Form -->
            <div class="bg-white rounded-lg shadow p-6 mb-8">
                <h2 class="text-xl font-bold mb-4">Add New Mentor</h2>
                <form method="POST" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <input type="hidden" name="add_mentor" value="1">
                    <input type="text" name="name" placeholder="Mentor Name" required class="border rounded px-3 py-2">
                    <input type="email" name="email" placeholder="Email" class="border rounded px-3 py-2">
                    <input type="text" name="phone" placeholder="Phone" class="border rounded px-3 py-2">
                    <button type="submit" class="bg-blue-600 text-white font-bold py-2 px-4 rounded hover:bg-blue-700">Add Mentor</button>
                </form>
            </div>

            <!-- Mentors List -->
            <div class="bg-white rounded-lg shadow overflow-hidden">
                <table class="min-w-full leading-normal">
                    <thead>
                        <tr>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Name</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Code</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Contact</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Completions</th>
                            <th class="px-5 py-3 border-b-2 border-gray-200 bg-gray-50 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Link</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($mentors as $m): ?>
                        <tr>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <p class="text-gray-900 whitespace-no-wrap font-bold"><?php echo htmlspecialchars($m['mentor_name']); ?></p>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <span class="relative inline-block px-3 py-1 font-semibold text-blue-900 leading-tight">
                                    <span aria-hidden class="absolute inset-0 bg-blue-200 opacity-50 rounded-full"></span>
                                    <span class="relative"><?php echo htmlspecialchars($m['mentor_code']); ?></span>
                                </span>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <p class="text-gray-900 whitespace-no-wrap"><?php echo htmlspecialchars($m['email']); ?></p>
                                <p class="text-gray-600 text-xs"><?php echo htmlspecialchars($m['phone']); ?></p>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <span class="relative inline-block px-3 py-1 font-semibold leading-tight <?php echo $m['status'] == 'active' ? 'text-green-900' : 'text-red-900'; ?>">
                                    <span aria-hidden class="absolute inset-0 <?php echo $m['status'] == 'active' ? 'bg-green-200' : 'bg-red-200'; ?> opacity-50 rounded-full"></span>
                                    <span class="relative"><?php echo ucfirst($m['status']); ?></span>
                                </span>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <p class="text-gray-900 whitespace-no-wrap font-bold text-center"><?php echo $m['completion_count']; ?></p>
                            </td>
                            <td class="px-5 py-5 border-b border-gray-200 bg-white text-sm">
                                <button onclick="copyLink('<?php echo BASE_URL . '/index.php?mentor=' . $m['mentor_code']; ?>')" class="text-blue-600 hover:text-blue-900">Copy</button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <script>
        function copyLink(url) {
            navigator.clipboard.writeText(url);
            alert('Link copied to clipboard!');
        }
    </script>
</body>
</html>
