<?php
require_once '../includes/auth.php';
requireAdminLogin();

// Fetch key metrics
$stmt = $pdo->query("SELECT 
    COUNT(*) as started,
    SUM(CASE WHEN is_completed = 1 THEN 1 ELSE 0 END) as completed,
    AVG(CASE WHEN is_completed = 1 THEN quality_score ELSE NULL END) as avg_quality
    FROM survey_responses");
$metrics = $stmt->fetch();

$completion_rate = $metrics['started'] > 0 ? round(($metrics['completed'] / $metrics['started']) * 100, 1) : 0;
$avg_quality = $metrics['avg_quality'] ? round($metrics['avg_quality'] * 100, 1) : 0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard - BodhiTree Survey</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&display=swap" rel="stylesheet">
</head>
<body class="bg-gray-100 font-sans">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <div class="bg-slate-800 text-white w-64 flex-shrink-0">
            <div class="p-4 text-xl font-bold border-b border-slate-700">BodhiTree Admin</div>
            <nav class="mt-4">
                <a href="dashboard.php" class="block py-3 px-4 bg-slate-700 border-l-4 border-blue-500">Dashboard</a>
                <a href="surveys.php" class="block py-3 px-4 hover:bg-slate-700">Surveys</a>
                <a href="analytics.php" class="block py-3 px-4 hover:bg-slate-700">Analytics</a>
                <a href="mentors.php" class="block py-3 px-4 hover:bg-slate-700">Mentors</a>
                <a href="responses.php" class="block py-3 px-4 hover:bg-slate-700">Responses</a>
                <a href="freebies.php" class="block py-3 px-4 hover:bg-slate-700">Freebies</a>
                <a href="logout.php" class="block py-3 px-4 hover:bg-slate-700 text-red-300">Logout</a>
            </nav>
        </div>

        <!-- Content -->
        <div class="flex-1 overflow-auto p-8">
            <h1 class="text-3xl font-bold text-gray-800 mb-8">Overview</h1>

            <!-- Cards -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">Started</h3>
                    <p class="text-3xl font-bold text-gray-900 mt-2"><?php echo number_format($metrics['started']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">Completed</h3>
                    <p class="text-3xl font-bold text-gray-900 mt-2"><?php echo number_format($metrics['completed']); ?></p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">Completion Rate</h3>
                    <p class="text-3xl font-bold text-blue-600 mt-2"><?php echo $completion_rate; ?>%</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium uppercase">Quality Score</h3>
                    <p class="text-3xl font-bold text-green-600 mt-2"><?php echo $avg_quality; ?>%</p>
                </div>
            </div>

            <!-- Charts Placeholder -->
            <div class="bg-white rounded-lg shadow p-6 mb-8">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Daily Completions (Last 30 Days)</h3>
                <div class="h-64 bg-gray-50 flex items-center justify-center text-gray-400">
                    [Chart Placeholder - Requires Chart.js]
                </div>
            </div>
        </div>
    </div>
</body>
</html>
